<section
    id="new-features"
    class="py-4 bg-white sm:py-6 lg:py-10 border rounded-xl border-gray-400 mt-5 max-w-[1300px] flex justify-center m-auto bg-gradient-to-t from-sky-100 shadow-md"
>
    <div class="px-4 mx-auto max-w-5xl sm:px-2 lg:px-4">
        <div class="text-center">
            <h4 class="text-lg font-bold leading-tight text-gray-900 sm:text-2xl xl:text-4xl">
                What We Offer
            </h4>
            <p class="mt-3 text-base leading-7 text-gray-600 sm:mt-6">
                We provide a wide range of services to help your business succeed
                online:
            </p>
        </div>

        <div class="grid grid-cols-1 mt-8 text-center sm:mt-10 sm:grid-cols-2 sm:gap-x-12 gap-y-12 md:grid-cols-3 md:gap-0 xl:mt-12">

            {{-- Feature 1: Web Hosting --}}
            <div class="md:p-8 lg:p-10 flex flex-col justify-center items-center">
                <div class="h-10 flex justify-center items-center mt-5">
                    <img src="{{ asset('assets/wh011.png') }}" alt="Web Hosting" />
                </div>
                <h3 class="mt-10 text-lg font-bold text-gray-900">
                    Web Hosting
                </h3>
                <p class="mt-5 text-base text-gray-600">
                    Fast, dependable, and scalable hosting that keeps your website up
                    and running smoothly around the clock.
                </p>
            </div>

            {{-- Feature 2: VPS Hosting --}}
            <div class="md:p-8 lg:p-10 md:border-l md:border-gray-400 flex flex-col justify-center items-center">
                <div class="relative bottom-2 flex justify-center items-center mb-2">
                    <img src="{{ asset('assets/vps012.png') }}" alt="VPS Hosting" />
                </div>
                <h3 class="mb-5 text-lg font-bold text-gray-900">
                    VPS Hosting
                </h3>
                <p class="mb-4 text-base text-gray-600">
                    Secure and flexible Virtual Private Servers to handle your
                    projects with ease and reliability.
                </p>
            </div>

            {{-- Feature 3: Cloud Hosting --}}
            <div class="md:p-8 lg:p-10 md:border-l md:border-gray-400 flex flex-col justify-center items-center">
                <div class="h-12 rounded-full flex justify-center items-center">
                    <img src="{{ asset('assets/cloud004.png') }}" alt="Cloud Hosting" />
                </div>
                <h3 class="mt-10 text-lg font-bold text-gray-900">
                    Cloud Hosting
                </h3>
                <p class="mt-5 text-base text-gray-600">
                    Future-proof your business with our reliable cloud hosting
                    services that grow alongside you.
                </p>
            </div>

            {{-- Feature 4: Email Marketing Servers --}}
            <div class="md:p-8 lg:p-10 md:border-t md:border-gray-400 flex flex-col justify-center items-center">
                <div class="relative top-4 rounded-full flex justify-center items-center">
                    <img class="w-28" src="{{ asset('assets/mail02.png') }}" alt="Email Marketing Servers" />
                </div>
                <h3 class="mt-14 text-lg font-bold text-gray-900">
                    Email Marketing Servers
                </h3>
                <p class="mt-3 text-base text-gray-600">
                    Run effective email campaigns with our dedicated servers, built
                    for precision and reliability.
                </p>
            </div>

            {{-- Feature 5: Dedicated /24IP Solution --}}
            <div class="md:p-8 lg:p-10 md:border-l md:border-gray-400 md:border-t flex flex-col justify-center items-center">
                <div class="relative -top-5 flex justify-center items-center">
                    <img class="w-56" src="{{ asset('assets/ip01.png') }}" alt="Dedicated /24IP Solution" />
                </div>
                <h3 class="mt-1 text-lg font-bold text-gray-900">
                    Dedicated /24IP Solution
                </h3>
                <p class="mt-3 text-base text-gray-600">
                    Take control with customized IP blocks tailored to meet your
                    specific needs.
                </p>
            </div>

            {{-- Feature 6: Website Design --}}
            <div class="md:p-8 lg:p-10 md:border-l md:border-gray-400 md:border-t flex flex-col justify-center items-center">
                <div class="relative top-1 flex justify-center items-center">
                    <img class="w-60" src="{{ asset('assets/web02.png') }}" alt="Website Design" />
                </div>
                <h3 class="mt-6 text-lg font-bold text-gray-900">
                    Website Design
                </h3>
                <p class="mt-10 text-base text-gray-600">
                    Impress your audience with stunning, modern, and mobile-friendly
                    designs crafted to reflect your brand perfectly.
                </p>
            </div>

            {{-- Feature 7: Python Hosting --}}
            <div class="md:p-8 lg:p-10 md:border-t md:border-gray-400 flex flex-col justify-center items-center">
                <div class="rounded-full flex justify-center items-center">
                    <img src="{{ asset('assets/py03.png') }}" alt="Python Hosting" />
                </div>
                <h3 class="mt-3 text-lg font-bold text-gray-900">
                    Python Hosting
                </h3>
                <p class="mt-5 text-base text-gray-600">
                    Hosting made for developers! Run your Python apps on fast, secure,
                    and optimized platforms.
                </p>
            </div>

            {{-- Feature 8: Forex/Trading Servers --}}
            <div class="md:p-8 lg:p-10 md:border-l md:border-gray-400 md:border-t flex flex-col justify-center items-center">
                <div class="relative top-4 w-52 h-14 rounded-full flex justify-center items-center">
                    <img src="{{ asset('assets/forex005.png') }}" alt="Forex/Trading Servers" />
                </div>
                <h3 class="mt-12 text-lg font-bold text-gray-900">
                    Forex/Trading Servers
                </h3>
                <p class="mt-5 text-base text-gray-600">
                    Gain an edge in trading with ultra-fast and highly secure servers
                    built for the financial market.
                </p>
            </div>

            {{-- Feature 9: Proxy Servers --}}
            <div class="md:p-8 lg:p-10 md:border-l md:border-gray-400 md:border-t flex flex-col justify-center items-center">
                <div class="relative top-3 w-44 h-14 rounded-ful flex justify-center items-center">
                    <img src="{{ asset('assets/proxy0006.png') }}" alt="Proxy Servers" />
                </div>
                <h3 class="mt-12 text-lg font-bold text-gray-900">
                    Proxy Servers
                </h3>
                <p class="mt-5 text-base text-gray-600">
                    Protect your online presence with high-performance proxy solutions
                    that enhance privacy and security.
                </p>
            </div>

            {{-- Feature 10: Google Workspace --}}
            <div class="md:p-8 lg:p-10 md:border-t md:border-gray-400 flex flex-col justify-center items-center">
                <div class="relative -top-5 w-28 h-14 flex justify-center items-center">
                    <img src="{{ asset('assets/google.png') }}" alt="Google Workspace" />
                </div>
                <h3 class="mt-2 text-lg font-bold text-gray-900">
                    Google Workspace
                </h3>
                <p class="mt-6 text-base text-gray-600">
                    Google Workspace simplifies teamwork with powerful tools like Gmail, Docs, Drive, and Meet, all seamlessly integrated.
                </p>
            </div>

            {{-- Feature 11: Microsoft 365 --}}
            <div class="md:p-8 lg:p-10 md:border-l md:border-gray-400 md:border-t flex flex-col justify-center items-center">
                <div class="relative top-0 w-44 h-14 rounded-full flex justify-center items-center">
                    <img src="{{ asset('assets/win007.png') }}" alt="Microsoft 365" />
                </div>
                <h3 class="mt-7 text-lg font-bold text-gray-900">
                    Microsoft 365
                </h3>
                <p class="mt-5 text-base text-gray-600">
                    Microsoft 365 enhances productivity with robust tools like Word, Excel, Teams, and OneDrive, all designed for seamless collaboration.
                </p>
            </div>

            {{-- Feature 12: License --}}
            <div class="md:p-8 lg:p-10 md:border-l md:border-gray-400 md:border-t flex flex-col justify-center items-center">
                <div class="relative top-3 w-20 h-14 rounded-ful flex justify-center items-center">
                    <img src="{{ asset('assets/key.png') }}" alt="License" />
                </div>
                <h3 class="mt-7 text-lg font-bold text-gray-900">
                    License
                </h3>
                <p class="mt-5 text-base text-gray-600">
                    Ensure smooth operations with secure and reliable licensing solutions. Empower your infrastructure with scalability and performance.
                </p>
            </div>

        </div>
    </div>
</section>
